#!/usr/bin/env python  
# -*- coding: utf-8 -*- 
# Powyższe dwa kody muszą być pierwszymi we wtyczce
# Pierwszy to informacja dla systemu, oznaczająca, 
# że w przypadku wykonywania programu powinien on być uruchamiany za 
# pomocą tego właśnie interpretera, czyli, że musi znaleźć lokalizację 
# Pythona za pomocą programu env do którego została podana ścieżka, 
# i dopiero wtedy użyć go jako interpretera. 
# Drugim definiujemy kodowanie znaków, Python musi wiedzieć, 
# że Nasza wtyczka nie jest w ANSI.

# GIMP Python plug-in template showing all UI elements.
# Copyright 2010 Akkana Peck <akkana@shallowsky.com>
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Uwaga: w gimpfu.py jest najbardziej aktualna lista elementów UI
'''
Prezentacja widgets - widżetów, (element interfejsu graficznego, skrót od "window gadget"
dla wtyczek GIMP-a w Python-ie 
(w MS Windows używają w tym kontekście terminu "kontrolka" lub "element kontrolny") 

Wtyczka jest szablonem specyfikacji dla rejestracji parametrów, 
demonstrującym jak je programować i jak wyglądają w GUI.

Uwagi:
Istnieją podobne typy nazw SF_xxx dla Scheme i języka C.
Przykład publikacja: http://www.gimpuj.info/index.php?topic=53173.0

Podręcznik stylu GUI: 
  Nie używamy wielkich liter w pokazanych tutaj opisach, jako dużą piszemy tylko pierwszą literę.
  Należy używać dwukropka po opisie procedury.
  Wskazane używać skrótów klawiaturowych (podkreślenie przed pierwszą literą Napisu w ścieżce).
  W nazwie Etykiety otwierającej okno dialogowe, używamy wielokropka ... 
  Zalecanym jest przyzwyczajenie się do pisania wyłącznie pojedynczych linii logicznych 
  w pojedynczych liniach fizycznych. Tylko w przypadku naprawdę długich linii logicznych 
  możemy je zapisać w kilku liniach fizycznych (patrz poniżej w def).
  
  Niektórzy zalecają dokładnie pisać opisy uzasadniające. 
'''
# Tłumaczenie i rozszerzenie wtyczki 30.05.2015, Zbigniew Małach 


# Poniższe mówi Pythonowi skąd ma załadować moduły gimpfu. 
from gimpfu import *

# To jest procedura, która będzie wykonywać faktyczne czynności
def show_py_ui(number, angle, word, text, bgcolor,
        newimg, newlayer, channel, drawable,
        shadowp, ascendingp, imgfmt, option,
        size, opacity, imagefile, dir,
        font, brush, pattern, gradient, palette):
    return
# Rejestrujemy procedurę w PDB 
register(
        "ui_options",  # Jeśli tak zapiszemy nazwę procedury rejestrującej wtyczkę, GIMP zmieni 
		  #podkreślenia na myślniki i doda prefiks "python-fu (samemu lepiej prefiksu nie dodawać).
        "Pokaz wszystkich opcji GUI Python-fu "+"\n "+__file__,  # Krótki opis działań wykonywanych 
		# przez wtyczkę, zobaczymy go po umieszczeniu wskaźnika myszki na Etykiecie (nazwie punktu w menu),
		# można ewentualnie dodatkowo podać (wg podanego wzoru) ścieżkę do katalogu z nazwą wtyczki. 
		# Powyższe pojawi się również w Przeglądarce procedur.
        "Nic nie robi, ale wyświetla wbudowane do okna wtyczki elementy interfejsu graficznego widgets",  
		# Długa Informacja dokumentacyjna o wtyczce, która pojawi się w Przeglądarce procedur, 
		# należy wyjaśnić w bardziej szczegółowy sposób funkcje realizowane przez wtyczkę. 
        "Nazwisko Autora",
        "Właściciel praw Autorskich + Copyright",  # Informacja o właścicielu prawach autorskich (Copyright) 
		# i np. GPL (General Public License) oraz ewent. adres email
        "2015",  # Data utworzenia wtyczki
        "_Pokaz opcji UI...",  # # Etykieta, nazwa punktu w menu, za pomocą której, wtyczka będzie uruchamiana. 
		  # W nazwie Etykiety otwierającej okno dialogowe, używamy wielokropka ... 
		  # Zastosowanie znaku podkreślenia "_" przed pierwszym znakiem powinno spowodować, że możemy używać 
		  # skrótu klawiaturowego, wygoda jeżeli w Katalogu/podkatalogu znajduje sie więcej wtyczek.
		  # Zaznaczamy katalog i kilkamy na literę skrótu.
        "",     # Typ obrazu z którym wtyczka może współpracować, to oznaczenie dotyczy tworzenia nowego obrazu, 
				# nie działa na istniejącym.
        [
            (PF_INT, "number", "Liczba?", 50),  # Liczby całkowite
            (PF_FLOAT, "angle", "Kąt", 3.14159), # Liczby zmiennoprzecinkowe
            # można także użyć PF_INT8, PF_INT16, PF_INT32
            (PF_STRING, "word", "Słowo", "Ahoj!"),
            # PF_VALUE to inny termin dla PF_STRING
            (PF_TEXT, "text", "Trochę tekstu",
                "Witam, w pierwszej wtyczce Python!"),

            (PF_COLOR, "bg-color", "Tło", (1.0, 1.0, 1.0)), # Potrójny parametr RGB
            # lub można to pisać jako alias PF_COLOUR

            (PF_IMAGE, "image", "Obraz wejściowy", None),
            (PF_LAYER, "layer", "Warstwa wejściowa", None),
            (PF_CHANNEL, "channel", "Który kanał", None),
            (PF_DRAWABLE, "drawable", "Wejście drawable", None),

            (PF_TOGGLE, "shadow", "Cień?", 1),
            (PF_BOOL,   "ascending", "_Rosnąco", True),
            (PF_RADIO, "imagefmt", "Format obrazu", "jpg", 
                (("png", "png"), ("jpg", "jpg"))), # Nazwy przycisków grupy opcji
            (PF_OPTION, "option", "Opcja", 2, ("Mysz", "Kot", "Pies", "Koń")),

            (PF_SPINNER, "size", "Rozmiar piksela", 50, (1, 8000, 1)),
            (PF_SLIDER, "opacity",  "Krycie", 100, (0, 100, 1)),
            # (PF_ADJUSTMENT jest taki sam jak PF_SPINNER

            (PF_FILE, "imagefile", "Plik obrazu", ""),  # Pozwala wybrać 
			# plik lub katalog, w zależności od tego, co jest domyślnym ciągiem znaków.
			# Jeśli umieścisz '/' (ukośnik) na koniec domyślnego ciągu znaków to poprosi 
			# o podanie katalogu. 
			#Jeśli pominiemy "/" (ukośnik) na końcu domyślnego ciąg znaków poprosi o plik. 
            (PF_DIRNAME, "dir", "Katalog", "/tmp"), # Pozwala wybrać tylko katalog

            (PF_FONT, "font", "Czcionka", "Sans"),
            (PF_BRUSH, "brush", "Pędzel", None),
            (PF_PATTERN, "pattern", "Deseń", None),
            (PF_GRADIENT, "gradient", "Gradient", None),
            (PF_PALETTE, "palette",  "Paleta", ""),
			
			# (PF_REGION, "region",_("Region"), 100), może działać, ale chyba mało 
			# użyteczne. Zobacz gimpfu.py.
			# (PF_FILENAME, "filename", _("Nazwa pliku"), ""), # Pozwala wybrać tylko plik. 
            # (PF_VECTORS, "vectors", "Vectors", None),
            # (PF_DISPLAY, "display", "Display", None),


            
        ],  #Pomiędzy tymi nawiasami klamrowymi zawarte są wyświetlane parametry GUI w interaktywnym oknie wtyczki
        [], # Spis zmiennych, które zwróci wtyczka - rezultat
        
		show_py_ui, menu="<Image>/TEST" # Nazwa procedury (funkcji) podana w def i ścieżka do punktu menu GIMP, 
		# gdzie powinna się znajdować Etykieta uruchamiania okna wtyczki, w nazwie etykiety używamy wielokropka ..., 
		#(ścieżka do menu musi startować z np. <Image> lub <Toolbox> czy <Layers>, wszędzie 
		#gdzie czujemy jej miejsce (może zawierać rozbudowaną ścieżkę)
		
		)

main()  # Uruchamia wtyczkę